import sys

sys.path.append("../")

import numpy as np
from typing import List
from methods.saddle import Logger, CentralizedSaddleSliding, ConstraintsL2
from oracles.saddle import ArrayPair, BaseSmoothSaddleOracle


class CentralizedSaddleSlidingRunner(object):
    def __init__(
            self,
            oracles: List[BaseSmoothSaddleOracle],
            L: float,
            mu: float,
            delta: float,
            r_x: float,
            r_y: float,
            eps: float,
            logger: Logger
    ):
        self.oracles = oracles
        self.L = L
        self.mu = mu
        self.delta = delta
        self.r_x = r_x
        self.r_y = r_y
        self.eps = eps
        self.logger = logger
        self._params_computed = False

    def compute_method_params(self):
        self.gamma = 0.1 
        self.gamma_inner = 1 / (self.gamma * self.L + 1)
        self.T_inner = 100
        self._params_computed = True
        print('SMMDS outer:', self.gamma, 'inner:', self.gamma_inner)
        

    def create_method(self, z_0: ArrayPair):
        if self._params_computed == False:
            raise ValueError("Call compute_method_params first")

        self.method = CentralizedSaddleSliding(
            oracles=self.oracles,
            stepsize_outer=self.gamma,
            stepsize_inner=self.gamma_inner,
            inner_iterations=self.T_inner,
            z_0=z_0,
            logger=self.logger,
            constraints=ConstraintsL2(self.r_x, self.r_y)
        )

    def run(self, max_iter, max_time=None):
        self.method.run(max_iter, max_time)
